package com.example.bytesbee.alphabets.activities;

import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.example.bytesbee.alphabets.activities.constants.IAlphaListener;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.constants.StaticNames;
import com.example.bytesbee.alphabets.activities.utils.AlphaTheme;
import com.example.bytesbee.alphabets.activities.utils.Utils;
import com.example.bytesbee.alphabets.activities.views.GestureDetectListner;
import com.example.bytesbee.alphabets.activities.R;
import com.polyak.iconswitch.IconSwitch;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class AlphabetActivity extends BaseActivity implements GestureDetectListner.SimpleGestureListener, View.OnClickListener {

    private ImageView imgAlphabet;
    private TextView txtThemeType;
    private GestureDetectListner detector;
    private int position = 0;
    private String strGender = AlphaTheme.MALE.toString();
    private IconSwitch iconSwitch;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        setContentView(R.layout.alphabet_activity);
        super.onCreate(savedInstanceState);

        imgAlphabet = findViewById(R.id.imgAlphabet);
        txtThemeType = findViewById(R.id.txtThemeType);

        iconSwitch = findViewById(R.id.iconSwitch);
        iconSwitch.setCheckedChangeListener(current -> {
            strGender = iconSwitch.getChecked() == IconSwitch.Checked.RIGHT ? AlphaTheme.FEMALE.toString() : AlphaTheme.MALE.toString();
            loadAudio(position);
            System.out.println("Prashant :: " + strGender + " >> " + position + " >> " + iconSwitch.getChecked());
        });

        detector = new GestureDetectListner(this, this);

        loadAudio(position);

        loadImageSource(position);

        final String strMyTheme = session.getAlphaValue();
        if (strMyTheme.equalsIgnoreCase(getString(R.string.strWords)) || strMyTheme.equalsIgnoreCase(getString(R.string.strPicture))) {
            iconSwitch.setVisibility(View.VISIBLE);
        } else {
            iconSwitch.setVisibility(View.GONE);
        }

        imgAlphabet.setOnClickListener(this);
        txtThemeType.setOnClickListener(this);
        btnPrevious.setOnClickListener(this);
        btnNext.setOnClickListener(this);
        play.setOnClickListener(this);

        Utils.loadBannerAd(mActivity);
    }


    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.imgAlphabet) {
            loadAudio(position);
        } else if (id == R.id.txtThemeType) {
            Utils.selectTheme(mActivity, session.getAlphaValue(), new IAlphaListener() {
                @Override
                public void clickListener(String strSelectedTheme) {
                    session.setAlphaValue(strSelectedTheme);
                    if (strSelectedTheme.equalsIgnoreCase(getString(R.string.strWords)) || strSelectedTheme.equalsIgnoreCase(getString(R.string.strPicture))) {
                        iconSwitch.setVisibility(View.VISIBLE);
                    } else {
                        iconSwitch.setVisibility(View.GONE);
                    }
                    loadImageSource(position);
                    loadAudio(position);
                }
            });
        } else if (id == R.id.btnPrev) {
            showPrevious();
        } else if (id == R.id.btnNext) {
            showNext();
        } else if (id == R.id.play) {
            playAudio(position);
        }
    }

    private void loadAudio(final int position) {
        String strPicture = getString(R.string.strPicture).toLowerCase();
        String strWords = getString(R.string.strWords).toLowerCase();

        bounceView(imgAlphabet);

        if (session.getAlphaValue().equalsIgnoreCase(strPicture)) {

            Utils.sout("strPicture:: " + strPicture + IConstants.UNDERSCORE + strGender + " >> " + StaticNames.STR_ALPHABETS[position]);
            playAudio(Utils.getRawAudio(mActivity, strPicture + IConstants.UNDERSCORE + strGender, StaticNames.STR_ALPHABETS[position]));

        } else if (session.getAlphaValue().equalsIgnoreCase(strWords)) {

            final String samePicture = StaticNames.STR_WORDS_ALPHABETS[position].length() == 2 ? strPicture + IConstants.UNDERSCORE + strGender : strWords + IConstants.UNDERSCORE + strGender;

            Utils.sout("strWords :: " + samePicture + " >> " + StaticNames.STR_WORDS_ALPHABETS[position]);
            playAudio(Utils.getRawAudio(mActivity, samePicture, StaticNames.STR_ALPHABETS[position]));

        } else {

            playAudio(Utils.getRawAudioDefault(mActivity, StaticNames.STR_ALPHABETS[position]));

        }
    }

    private void loadImageSource(final int position) {
        String themeType = session.getAlphaType();
        txtThemeType.setText(String.format(getString(R.string.themeSelected), session.getAlphaValue().toUpperCase()));
        imgAlphabet.setImageResource(Utils.getDrawableImage(mActivity, themeType, StaticNames.STR_ALPHABETS[position]));
    }

    private void updateActivity(final int position) {
        loadImageSource(position);
        loadAudio(position);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent me) {
        this.detector.onTouchEvent(me);
        return super.dispatchTouchEvent(me);
    }

    @Override
    public void onSwipe(int direction) {
        switch (direction) {

            case GestureDetectListner.SWIPE_RIGHT:
                showPrevious();
                break;

            case GestureDetectListner.SWIPE_LEFT:
                showNext();
                break;
        }

    }

    private void showPrevious() {
        if (position > 0) {
            updateActivity(position - 1);
            position = position - 1;
        } else {
            updateActivity((StaticNames.STR_ALPHABETS.length - 1));
            position = StaticNames.STR_ALPHABETS.length - 1;
        }
    }

    private void showNext() {
        if (position < (StaticNames.STR_ALPHABETS.length - 1)) {
            updateActivity(position + 1);
            position = position + 1;
        } else {
            updateActivity(0);
            position = 0;
        }
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}